/**
 * Pyro object
 *
 * The Pyro object is the foundation of all PyroUI enhancements
 */
jQuery(function($) {

	/**
	 * This initializes all JS goodness
	 */
	pyro.init = function() {
		$("#datepicker").datepicker({dateFormat: 'yy-mm-dd'});
		
		$("#main-nav li a.top-link").click(function () {
			if($(this).hasClass("no-submenu"))
			{
				return true;
			}
			$(this).parent().find('ul').toggle();
			$(this).parent().siblings().find('ul').hide();
			return false;
		});
		
		$('#main-nav ul li').mouseleave(function(){
			$(this).find('ul').fadeOut();
		});

		// Add the close link to all boxes with the closable class
		$('.closable').livequery(function(){
			$(this).append('<a href="#" class="close">close</a>');
		});

		// Close the notifications when the close link is clicked
		$('a.close').live('click', function(e){
			e.preventDefault();
			$(this).fadeTo(200, 0); // This is a hack so that the close link fades out in IE
			$(this).parent().fadeTo(200, 0);
			$(this).parent().slideUp(400, function(){
				$(this).remove();
			});
		});

		// Fade in the notifications
		$('.notification').livequery(function(){
			$(this).fadeIn('slow', function(){
				$(window).trigger('notification-complete');
			});
		});

		// Check all checkboxes in container table or grid
		$(".check-all").live('click', function () {
			var check_all		= $(this),
				all_checkbox	= $(this).is('.grid-check-all')
					? $(this).parents(".list-items").find(".grid input[type='checkbox']")
					: $(this).parents("table").find("tbody input[type='checkbox']");

			all_checkbox.each(function () {
				if (check_all.is(":checked") && ! $(this).is(':checked'))
				{
					$(this).click();
				}
				else if ( ! check_all.is(":checked") && $(this).is(':checked'))
				{
					$(this).click();
				}
			});

			// Update uniform if enabled
			$.uniform && $.uniform.update();
		});

		// Confirmation
		$('a.confirm').live('click', function(e){
			e.preventDefault();

			var href		= $(this).attr('href'),
				removemsg	= $(this).attr('title');

			if (confirm(removemsg || DIALOG_MESSAGE))
			{
				$(this).trigger('click-confirmed');

				if ($.data(this, 'stop-click')){
					$.data(this, 'stop-click', false);
					return;
				}

				//submits it whether uniform likes it or not
				window.location.replace(href);
			}
		});
		
		//use a confirm dialog on "delete many" buttons
		$(':submit.confirm').live('click', function(e, confirmation){

			if (confirmation)
			{
				return true;
			}

			e.preventDefault();

			var removemsg = $(this).attr('title');

			if (confirm(removemsg || DIALOG_MESSAGE))
			{
				$(this).trigger('click-confirmed');

				if ($(this).data('stop-click')){
					$(this).data('stop-click', false);
					return;
				}

				$(this).trigger('click', true);
			}
		});

		// Table zerbra striping
		$("tbody tr:nth-child(even)").livequery(function () {
			$(this).addClass("alt");
		});

		$('.tabs').livequery(function () {
			$(this).tabs({
				cookie: { expires: 1 }
			});
		});		
		$('#tabs').livequery(function () {
			$(this).tabs({
				// This allows for the Back button to work.
				select: function(event, ui) {
					parent.location.hash = ui.tab.hash;
				},
				load: function(event, ui) {
					confirm_links();
					confirm_buttons();
				}
			});
		});

		$("select, textarea, input[type=text], input[type=file], input[type=submit]").livequery(function(){
			$(this).not('.no-uniform').uniform().addClass('no-uniform');
		});

		var current_module = $('#page-header h1 a').text();
		// Fancybox modal window
		$('a[rel=modal], a.modal').livequery(function() {
			$(this).colorbox({
				width: "60%",
				maxHeight: "90%",
				current: current_module + " {current} / {total}"
			});
		});

		$('a[rel="modal-large"], a.modal-large').livequery(function() {
			$(this).colorbox({
				width: "90%",
				height: "95%",
				iframe: true,
				scrolling: false,
				current: current_module + " {current} / {total}"
			});
		});
	};

	pyro.clear_notifications = function()
	{
		$('.notification .close').click();

		return pyro;
	};

	pyro.add_notification = function(notification, options, callback)
	{
		var defaults = {
			clear	: true,
			ref		: '#shortcuts',
			method	: 'after'
		}, opt;
		
		// extend options
		opt = $.isPlainObject(options) ? $.extend(defaults, options) : defaults;

		// clear old notifications
		opt.clear && pyro.clear_notifications();

		// display current notifications
		$(opt.ref)[opt.method](notification);
	
		// call callback
		$(window).one('notification-complete', function(){
			callback && callback();
		});

		return pyro;
	};

	$(document).ready(function() {
		pyro.init();
	});
	
	//close colorbox only when cancel button is clicked
	$('#cboxLoadedContent a.cancel').live('click', function(e) {
		e.preventDefault();
		$.colorbox.close();
	});
	
	// toggle a site's upload settings
	$('.addons-upload').on('click', 'input:checkbox', function(e) {
		e.preventDefault();
		var checkbox = $(this);
		var site_ref = checkbox.attr('id');
		var state = checkbox.is(':checked') ? 1 : 0;

		// disable to keep them from double clicking
		checkbox.attr('disabled', true);

		$.post(SITE_URL + 'sites/settings/toggle_upload', { 'site_ref': site_ref, 'state': state }, function(data) {
			var result = $.parseJSON(data);
				
			if (result.status == 'success') {
				// Success!  Swap colors and words
				checkbox.parent().find('span').toggle();
				
				// Allow the checkbox to check (or uncheck)
				checkbox.prop('checked', state);
			}
			checkbox.removeAttr('disabled');
		});
	})
	
	// toggle a site's upload settings
	$('.active').on('click', 'input:checkbox', function(e) {
		e.preventDefault();
		var checkbox = $(this);
		var site_ref = checkbox.attr('id');
		var state = checkbox.is(':checked') ? 1 : 0;

		// disable to keep them from double clicking
		checkbox.attr('disabled', true);

		$.post(SITE_URL + 'sites/status', { 'site_ref': site_ref, 'state': state }, function(data) {
			var result = $.parseJSON(data);
				
			if (result.status == 'success') {
				// Success!  Swap colors and words
				checkbox.parent().find('span').toggle();
				
				// Allow the checkbox to check (or uncheck)
				checkbox.prop('checked', state);
			}
			checkbox.removeAttr('disabled');
		});
	})
});

//functions for codemirror
function html_editor(id, width)
{
	CodeMirror.fromTextArea(id, {
	    height: "30em",
	    width: width,
	    parserfile: ["parsejavascript.js","parsexml.js", "parsecss.js", "parsehtmlmixed.js"],
	    stylesheet: [APPPATH_URI + "assets/css/codemirror/xmlcolors.css", APPPATH_URI + "assets/css/codemirror/csscolors.css"],
	    path: APPPATH_URI + "assets/js/codemirror/",
	    tabMode: 'spaces'
	});
}

function css_editor(id, width)
{
	CodeMirror.fromTextArea(id, {
	    height: "30em",
	    width: width,
	    parserfile: "parsecss.js",
	    stylesheet: APPPATH_URI + "assets/css/codemirror/csscolors.css",
	    path: APPPATH_URI + "assets/js/codemirror/"
	});
}

function js_editor(id, width)
{
	CodeMirror.fromTextArea(id, {
	    height: "30em",
	    width: width,
	    parserfile: ["tokenizejavascript.js", "parsejavascript.js"],
	    stylesheet: APPPATH_URI + "assets/css/codemirror/jscolors.css",
	    path: APPPATH_URI + "assets/js/codemirror/"
	});
}


/*
 * jQuery throttle / debounce - v1.1 - 3/7/2010
 * http://benalman.com/projects/jquery-throttle-debounce-plugin/
 *
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function(b,c){var $=b.jQuery||b.Cowboy||(b.Cowboy={}),a;$.throttle=a=function(e,f,j,i){var h,d=0;if(typeof f!=="boolean"){i=j;j=f;f=c}function g(){var o=this,m=+new Date()-d,n=arguments;function l(){d=+new Date();j.apply(o,n)}function k(){h=c}if(i&&!h){l()}h&&clearTimeout(h);if(i===c&&m>e){l()}else{if(f!==true){h=setTimeout(i?k:l,i===c?e-m:e)}}}if($.guid){g.guid=j.guid=j.guid||$.guid++}return g};$.debounce=function(d,e,f){return f===c?a(d,e,false):a(d,f,e!==false)}})(this);